<?php
/**
 * Frontend class
 *
 * @author YITH
 * @package YITH_Store_Locator_Frontend
 * @version 1.0.0
 */

defined( 'YITH_SL' ) || exit; // Exit if accessed directly

if ( ! class_exists( 'Abstract_YITH_Store_Locator_Shortcode' ) ) {
    /**
     * Abstract_YITH_Store_Locator_Shortcode
     *
     * @since 1.0.0
     */
    class Abstract_YITH_Store_Locator_Shortcode {

        public static $name;


        public $atts = array();


        /**
         * Constructor
         *
         * @return void
         * @since 1.0.0
         */
        public function __construct() {
            add_shortcode( $this::$name, array( $this, 'callback' ) );

        }


        public function set( $attr, $value ){
            $this->atts[ $attr ] = $value;
        }


        public function __get( $attr ){

            if(array_key_exists( $attr, $this->atts )){
                $value =  $this->atts[$attr];
            }else{
                $value = $this->get_default_value( $attr );
            }
            return $value;
        }


        public function get_default_value( $attr ){
            $value = '';

            switch ( $attr ){
                case '':
                    // Do something
                    break;

                default:
                    break;
            }

            return $value;

        }


        public function callback( $atts ){

            foreach ( $this->atts as $key => $value ){

                $value = isset( $atts[$key] ) ? $atts[$key] : $this->get_default_value( $key );

                $this->set( $key, $value );
            }

            $this->before_output();

            return $this->output();
        }


        public function output(){
            //do somethingre
            return '';
        }

        public function before_output(){
            //do something
        }



    }
}
