<?php
/**
 * Admin class
 *
 * @author YITH
 * @package YITH Store Locator
 * @version 1.0.0
 */

defined( 'YITH_SL' ) || exit; // Exit if accessed directly

if ( ! class_exists( 'YITH_Store_Locator_Frontend_Scripts' ) ) {
    /**
     * YITH Store Locator
     *
     * @since 1.0.0
     */
    final class YITH_Store_Locator_Frontend_Scripts {

        /**
         * Single instance of the class
         *
         * @var YITH_Store_Locator_Admin
         * @since 1.0.0
         */
        private static $instance;


        /**
         * Returns single instance of the class
         *
         * @return YITH_Store_Locator_Frontend_Scripts
         * @since 1.0.0
         */
        public static function get_instance(){
            if( is_null( self::$instance ) ){
                self::$instance = new self();
            }
            return self::$instance;
        }


        /**
         * Constructor
         *
         * @return void
         * @since 1.0.0
         */
        private function __construct() {

            add_action( 'wp_enqueue_scripts',[ $this, 'register_scripts' ] );

            add_action( 'wp_enqueue_scripts', [ $this, 'enqueue_scripts' ] );


        }


        public function register_scripts(){

            $suffix = (defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

            $gmap_api_key = yith_sl_get_option( 'google-maps-api-key' );
            wp_register_script('yith-sl-google-map','https://maps.googleapis.com/maps/api/js?key='. $gmap_api_key .'&libraries=places', array(),false,true );
            wp_register_style( 'yith-sl-single',YITH_SL_ASSETS_URL . 'css/frontend/single' . $suffix . '.css',YITH_SL_VERSION );
            wp_register_style( 'yith-sl-frontend',YITH_SL_ASSETS_URL . 'css/frontend/frontend' . $suffix . '.css',array(), YITH_SL_VERSION );
            wp_register_script( 'yith-store-locator',YITH_SL_ASSETS_URL . 'js/frontend/store-locator' . $suffix . '.js', array( 'jquery', 'yith-sl-google-map' ),YITH_SL_VERSION );
            wp_register_script( 'yith-store-locator-filters-dropdown',YITH_SL_ASSETS_URL . 'js/frontend/filters-dropdown' . $suffix . '.js', array( 'jquery' ),YITH_SL_VERSION );
            wp_register_script( 'yith-sl-single',YITH_SL_ASSETS_URL . 'js/frontend/single' . $suffix . '.js', array( 'jquery', ),YITH_SL_VERSION );

            if( defined( 'YITH_PROTEO_VERSION' ) ){
                wp_register_script( 'yith-sl-proteo',YITH_SL_ASSETS_URL . 'third-parts/proteo/proteo' . $suffix . '.js', array( 'jquery', ),YITH_SL_VERSION );
            }

        }


        public function enqueue_scripts(){

            $custom_css = yith_sl_get_option('custom-css');

            if( YITH_Store_Locator_Frontend::get_instance()->is_store_page() ){

                wp_enqueue_style( 'yith-sl-single' );
                wp_enqueue_script( 'yith-sl-single' );
                wp_add_inline_style( 'yith-sl-single', $custom_css );

            }elseif( YITH_Store_Locator_Frontend::get_instance()->is_store_locator_page() ){

                wp_enqueue_style( 'yith-sl-frontend' );

                wp_add_inline_style( 'yith-sl-frontend', $custom_css );

            }

            if( defined( 'YITH_PROTEO_VERSION' ) ){
                wp_enqueue_script( 'yith-sl-proteo' );
            }

            /* Inline scripts */

            $custom_js = yith_sl_get_option('custom-js' );
            wp_add_inline_script( 'jquery', $custom_js );

        }

    }
}

function YITH_Store_Locator_Frontend_Scripts(){
    return YITH_Store_Locator_Frontend_Scripts::get_instance();
}
