<?php
if (!defined('ABSPATH')) {
    exit; 
} 
if(!class_exists('WPWC_User_Registration_Settings')){
	class WPWC_User_Registration_Settings{
		public function __construct(){
			$current = isset( $_GET[ 'tab' ] ) ? $_GET[ 'tab' ] : 'wpwc-general-settings';
	        $tabs = array(
	        'wpwc-general-settings' => esc_html__('General', 'wpwc-registration' ),
			'wpwc-user-registration'=> esc_html__('Registration With Role', 'wpwc-registration' ),
			'wpwc-wooreg-fields'   	=> esc_html__('Registration Fields', 'wpwc-registration' ),
	        'wpwc-notification'     => esc_html__('Notifications', 'wpwc-registration')
	        );
	        $this->init_tabs(apply_filters('wpwc_user_registration_setting_tabs',$tabs));
	        $this->current_tab(apply_filters('wpwc_user_registration_current_setting_tab',$current));
		}
		public function init_tabs($tabs=array()){
	        $current = isset( $_GET[ 'tab' ] ) ? $_GET[ 'tab' ] : 'wpwc-general-settings';
	        $html = '<h5 class="nav-tab-wrapper">';
	        foreach( $tabs as $tab => $name ){
	        $class = ( $tab == $current ) ? 'nav-tab-active' : '';
	        $html .= '<a class="nav-tab ' . $class . '" href="'.esc_url(admin_url().'admin.php?page=wpwc-user-registration&tab='.$tab).'">'.esc_html($name).'</a>';
	        }
	        $html .= '</h5>';
	        echo $html;
	    }
	    public function current_tab($current='basic-settings'){
	        switch ($current) {
	        case 'wpwc-general-settings':
	            $this->general_settings();
	            break;
	        case 'wpwc-user-registration':
	            $this->registration_settings();
				break; 
			case 'wpwc-wooreg-fields':
				$this->registration_fields();
				break;   
	        case 'wpwc-notification':
	            $this->notification_settings();
	            break;      
	        default:
	            $this->general_settings();
	            break;
	        }
	    }
	    public function general_settings(){
    	?>
    	<div class="wrap">
            <form method="post" action="options.php">
                <?php settings_errors(); ?>
                <?php settings_fields('wpwc-user-general-settings-group'); ?>
                <?php do_settings_sections('wpwc-user-general-settings-group'); ?>
                 <table class="form-table">
                    <tr valign="top">
                        <th><label for="wpwc_enable_user_authentication">
                        	<?php esc_html_e("Enable Authentication","wpwc-registration"); ?></label>
                        </th>
                        <td><?php $value=get_option('wpwc_enable_user_authentication'); ?>
                        	<input type="checkbox" name="wpwc_enable_user_authentication" value="yes" id="wpwc_enable_user_authentication" <?php echo ($value=='yes') ? 'checked': ''; ?>>
                        	<span><?php esc_html_e("Enable this option to authenticate users before login with status.","wpwc-registration"); ?></span>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="wpwc_new_user_reg_authentication">
                        	<?php esc_html_e("New User Authentication Status","wpwc-registration"); ?></label>
                        </th>
                        <td><?php $value=get_option('wpwc_new_user_reg_authentication'); ?>
                        	<select name="wpwc_new_user_reg_authentication" value="yes" id="wpwc_new_user_reg_authentication">
                        		<option value=""><?php esc_html_e("Select status","wpwc-registration"); ?></option>
                        		<option value="active" <?php echo ($value=='active') ? 'selected' : ''; ?>><?php esc_html_e("Enable Login Access","wpwc-registration"); ?></option>
                        		<option value="disabled" <?php echo ($value=='disabled') ? 'selected' : ''; ?>><?php esc_html_e("Disable Login Access","wpwc-registration"); ?></option>
                        	</select>
                        	<span><?php esc_html_e("Choose option to whether new registered users can login or need admin approval.","wpwc-registration"); ?></span>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="wpwc_account_disable_error">
                        	<?php esc_html_e("Authentication Error","wpwc-registration"); ?></label>
                        </th>
                        <td><?php $value=get_option('wpwc_account_disable_error'); ?>
                        	<input type="text" name="wpwc_account_disable_error" value="<?php echo !empty($value) ? esc_attr($value) : ''; ?>" id="wpwc_account_disable_error" class="regular-text">
                        	<p><?php esc_html_e("Error message for disabled accounts on login.","wpwc-registration"); ?></p>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="wpwc_default_fields_position">
                        	<?php esc_html_e("Default Registration Fields Position","wpwc-registration"); ?></label>
                        </th>
                        <td><?php $value=get_option('wpwc_default_fields_position'); ?>
                        	<p><label><input type="radio" name="wpwc_default_fields_position" <?php checked('start', $value); ?> value="start"><?php esc_html_e("Start of the form","wpwc-registration"); ?></label></p>
                        	<p><label><input type="radio" name="wpwc_default_fields_position" <?php checked('end', $value); ?> value="end"><?php esc_html_e("End of the form","wpwc-registration"); ?></label></p>
                        	<p><?php esc_html_e("Select the default user registration fields position in the form on My Account Page.","wpwc-registration"); ?></p>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="wpwc_custom_fields_position">
                        	<?php esc_html_e("Custom Registration Fields Position","wpwc-registration"); ?></label>
                        </th>
                        <td><?php $value=get_option('wpwc_custom_fields_position'); ?>
                        	<p><label><input type="radio" name="wpwc_custom_fields_position" <?php checked('start', $value); ?> value="start"><?php esc_html_e("Start of the form","wpwc-registration"); ?></label></p>
                        	<p><label><input type="radio" name="wpwc_custom_fields_position" <?php checked('end', $value); ?> value="end"><?php esc_html_e("End of the form","wpwc-registration"); ?></label></p>
                        	<p><?php esc_html_e("Select the custom user registration fields position in the form on My Account Page.","wpwc-registration"); ?></p>
                        </td>
                    </tr>
                </table>
                <?php submit_button(); ?>
            </form>
        </div>
        <?php
	    }
	    public function registration_settings(){
	    ?>
    	<div class="wrap">
            <form method="post" action="options.php">
                <?php settings_errors(); ?>
                <?php settings_fields('wpwc-registration-settings-group'); ?>
                <?php do_settings_sections('wpwc-registration-settings-group'); ?>
                 <table class="form-table">
                    <tr valign="top">
                        <th><label for="wpwc_enable_user_role_field">
                        	<?php esc_html_e("User Role Selection.","wpwc-registration"); ?></label>
                        </th>
                        <td><?php $value=get_option('wpwc_enable_user_role_field'); ?>
                        	<input type="checkbox" name="wpwc_enable_user_role_field" value="yes" id="wpwc_enable_user_role_field" <?php echo ($value=='yes') ? 'checked': ''; ?>>
                        	<span><?php esc_html_e("Enable user role selection on registration form.","wpwc-registration"); ?></span>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="wpwc_user_role_field_label">
                        	<?php esc_html_e("User Role Field Label","wpwc-registration"); ?></label>
                        </th>
                        <td><?php $value=get_option('wpwc_user_role_field_label'); ?>
                        	<input type="text" name="wpwc_user_role_field_label" value="<?php echo !empty($value) ? esc_attr($value) : ''; ?>" id="wpwc_user_role_field_label" class="regular-text">
                        	<p><?php esc_html_e("User role field label for roles dropdown in registration form.","wpwc-registration"); ?></p>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="wpwc_user_role_field_required">
                        	<?php esc_html_e("Is Required?","wpwc-registration"); ?></label>
                        </th>
                        <td><?php $value=get_option('wpwc_user_role_field_required'); ?>
                        	<input type="checkbox" name="wpwc_user_role_field_required" value="yes" id="wpwc_user_role_field_required" <?php echo ($value=='yes') ? 'checked': ''; ?>>
                        	<span><?php esc_html_e("Is user role selection field required on registration form?","wpwc-registration"); ?></span>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="wpwc_user_role_approve_status">
                        	<?php esc_html_e("Requested Role Approval","wpwc-registration"); ?></label>
                        </th>
                        <td><?php $value=get_option('wpwc_user_role_approve_status'); ?>
                        	<select name="wpwc_user_role_approve_status" id="wpwc_user_role_approve_status">
                        		<option value=""><?php esc_html_e("Select status","wpwc-registration"); ?></option>
                        		<option value="auto" <?php echo ($value=='auto') ? 'selected' : ''; ?>><?php esc_html_e("Auto Approve","wpwc-registration"); ?></option>
                        		<option value="manual" <?php echo ($value=='manual') ? 'selected' : ''; ?>><?php esc_html_e("Manually Approve","wpwc-registration"); ?></option>
                        	</select>
                        	<span><?php esc_html_e("Choose option to whether new registered users role assignment can be done automatically or need admin approval.","wpwc-registration"); ?></span>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="wpwc_user_role_dropdown_options">
                        	<?php esc_html_e("Roles For Dropdown","wpwc-registration"); ?></label>
                        </th>
                        <td><?php $value=get_option('wpwc_user_role_dropdown_options'); 
                        	global $wp_roles;
				            $roles = $wp_roles->get_names(); ?>
				            <div class="postbox">
                        	<fieldset style="border:1px solid;padding:0.625em;margin:0.625em;">
                        		<legend><?php esc_html_e("Choose Roles","wpwc-registration"); ?></legend>
                        		<?php foreach ($roles as $key => $role) {
                        			$checked='';
                        			if(!empty($value) && in_array($key,$value))
                        				$checked="checked";
                        			echo '<p><label><input type="checkbox" value="'.esc_attr($key).'" name="wpwc_user_role_dropdown_options[]" '.$checked.'>'.esc_attr($role).'</label></p>';
                        		} ?>
                        	</fieldset>
	                        </div>
                        	<span><?php esc_html_e("Choose role to display in dropdown for user in registration form.","wpwc-registration"); ?></span>
                        </td>
                    </tr>
                </table>
                <?php submit_button(); ?>
            </form>
        </div>
        <?php
		}
		public function data_sort( $a, $b ) {
			if ( ! isset( $a['priority'], $b['priority'] ) ) {
				return -1;
			}
			if ( $a['priority'] == $b['priority'] ) {
				return 0;
			}
			return $a['priority'] < $b['priority'] ? -1 : 1;
		}
		public function registration_fields(){
			?>
			<div class="wrap wpwc_user_registration">
				<form method="post" action="options.php">
					<?php settings_errors(); ?>
					<?php settings_fields('wpwc-registration-fields-group'); ?>
					<?php do_settings_sections('wpwc-registration-fields-group'); ?>
					<h1><?php esc_html_e('Woocommerce Default Registration Fields','wpwc-registration'); ?></h1>
					<?php 
					$data=get_option('wpwc_fields_registration_form');
					$fields=array(
							'first_name' => array(
											'name'	=>	esc_html__('First Name','wpwc-registration'),
											'label'	=>	esc_html__('First Name','wpwc-registration'),
											'placeholder'=> esc_html__('Enter Name','wpwc-registration'),
											'description'	=>	esc_html__('Enter your first name.','wpwc-registration'),
											'required'	=>	'no',
											'class'		=>	'wpwc-full',
											'type'	=>	'text',
											'priority'	=>	isset($data['first_name']['priority']) ? $data['first_name']['priority'] : 0,
										),
							'last_name'	=> array(
											'name'	=>	esc_html__('Last Name','wpwc-registration'),
											'label'	=>	esc_html__('Last Name','wpwc-registration'),
											'placeholder'=> esc_html__('Enter Name','wpwc-registration'),
											'description'	=>	esc_html__('Enter your last name.','wpwc-registration'),
											'required'	=>	'no',
											'class'		=>	'wpwc-full',
											'type'	=>	'text',
											'priority'	=>	isset($data['last_name']['priority']) ? $data['last_name']['priority'] : 1,
										),
							'billing_company'=> array(
											'name'	=>	esc_html__('Company Name','wpwc-registration'),
											'label'	=>	esc_html__('Company Name','wpwc-registration'),
											'placeholder'=> esc_html__('Enter Company','wpwc-registration'),
											'description'	=>	esc_html__('Enter your company name.','wpwc-registration'),
											'required'	=>	'no',
											'class'		=>	'wpwc-full',
											'type'	=>	'text',
											'priority'	=>	isset($data['billing_company']['priority']) ? $data['billing_company']['priority'] : 2,
										),
							'billing_country'=>	array(
											'name'	=>	esc_html__('Country','wpwc-registration'),
											'label'	=>	esc_html__('Country','wpwc-registration'),
											'description'	=>	esc_html__('Select your country','wpwc-registration'),
											'required'	=>	'no',
											'class'		=>	'wpwc-full',
											'type'	=>	'country',
											'priority'	=>	isset($data['billing_country']['priority']) ? $data['billing_country']['priority'] : 3,
										),
							'billing_state'	=>	array(
											'name'	=>	esc_html__('State / Region','wpwc-registration'),
											'label'	=>	esc_html__('State / Region','wpwc-registration'),
											'description'	=>	esc_html__('Select your state/region','wpwc-registration'),
											'required'	=>	'no',
											'class'		=>	'wpwc-full',
											'type'		=>	'state',
											'priority'	=>	isset($data['billing_state']['priority']) ? $data['billing_state']['priority'] : 4,
										),
							'billing_address_1'=>	array(
											'name'	=>	esc_html__('Street Address','wpwc-registration'),
											'label'	=>	esc_html__('Street Address','wpwc-registration'),
											'placeholder'=> esc_html__('Enter Street Address','wpwc-registration'),
											'description'	=>	esc_html__('Enter your street address','wpwc-registration'),
											'required'	=>	'no',
											'class'		=>	'wpwc-full',
											'type'		=>	'text',
											'priority'	=>	isset($data['billing_address_1']['priority']) ? $data['billing_address_1']['priority'] : 5,
										),
							'billing_address_2'=>	array(
											'name'	=>	esc_html__('Address','wpwc-registration'),
											'label'	=>	esc_html__('Address','wpwc-registration'),
											'placeholder'=> esc_html__('Enter Address','wpwc-registration'),
											'description'	=>	esc_html__('Enter your address','wpwc-registration'),
											'required'	=>	'no',
											'class'		=>	'wpwc-full',
											'type'		=>	'text',
											'priority'	=>	isset($data['billing_address_2']['priority']) ? $data['billing_address_2']['priority'] : 6,
										),
							'billing_city'=>	array(
											'name'	=>	esc_html__('Town / City','wpwc-registration'),
											'label'	=> esc_html__('Town / City','wpwc-registration'),
											'placeholder'=> esc_html__('Enter City','wpwc-registration'),
											'description'	=>	esc_html__('Enter your city','wpwc-registration'),
											'required'	=>	'no',
											'class'		=>	'wpwc-full',
											'type'		=>	'text',
											'priority'	=>	isset($data['city']['priority']) ? $data['city']['priority'] : 7,
										),
							'billing_postcode'=>	array(
											'name'	=>	esc_html__('Zipcode','wpwc-registration'),
											'label'	=> esc_html__('Zipcode','wpwc-registration'),
											'placeholder'=> esc_html__('Enter Zipcode','wpwc-registration'),
											'description'	=>	esc_html__('Enter your zipcode','wpwc-registration'),
											'required'	=>	'no',
											'class'		=>	'wpwc-full',
											'type'		=>	'text',
											'priority'	=>	isset($data['billing_postcode']['priority']) ? $data['billing_postcode']['priority'] : 8,
										),
							'billing_phone'=>	array(
											'name'	=>	esc_html__('Phone','wpwc-registration'),
											'label'	=> esc_html__('Phone','wpwc-registration'),
											'placeholder'=> esc_html__('Enter Phone','wpwc-registration'),
											'description'	=>	esc_html__('Enter your phone','wpwc-registration'),
											'required'	=>	'no',
											'class'		=>	'wpwc-full',
											'type'		=> 'tel',
											'priority'	=>	isset($data['billing_phone']['priority']) ? $data['billing_phone']['priority'] : 9,
										),
						);
						uasort( $fields, array( $this, 'data_sort' ) );
						?>
					<div class="field_tabs">
						<?php $i=0; foreach ($fields as $key => $value) { ?>
						<div class="tabsingle">
							<div class="tab-header">
								<span class="field-name"><span class="dashicons dashicons-menu"></span>
								<?php echo $value['name']; ?></span>
								<span class="field-status">
									<label class="cboxswitch">
										<input type="checkbox" value="yes" <?php echo (isset($data[$key]['enable']) && $data[$key]['enable']=='yes') ? 'checked' :''; ?> id="cboxSwitchery" 
										name="wpwc_fields_registration_form[<?php echo $key ?>][enable]" class="cboxSwitchery">
										<span class="cboxslider cboxround" data-title="<?php esc_html_e('Enable/Disable','wpwc-registration') ?>"></span>
									</label>
								</span>
								<span class="field-toggle"><?php esc_html_e('Toggle','wpwc-registration'); ?></span>
							</div>
							<div class="tab-body">
								<div class="inner">
									<table class="form-table">
										<tbody>
										<?php if(isset($value['label'])): ?>
											<tr>
												<th><label for="wpwc_label"><?php esc_html_e("Field Label","wpwc-registration"); ?></label></th>
												<td><input type="text" name="wpwc_fields_registration_form[<?php echo $key ?>][label]" id="wpwc_label" class="regular-text" value="<?php echo (isset($data[$key]['label'])) ? esc_attr($data[$key]['label']) : esc_attr($value['label']); ?>">
													<input type="hidden" name="wpwc_fields_registration_form[<?php echo $key ?>][priority]" value="<?php echo (isset($data[$key]['priority'])) ? esc_attr($data[$key]['priority']) : $i; ?>" class="priority">
													<input type="hidden" name="wpwc_fields_registration_form[<?php echo $key ?>][type]" value="<?php echo esc_attr($value['type']); ?>"></td>
											</tr>
										<?php endif;
										 if(isset($value['placeholder'])): ?>
											<tr>
												<th><label for="wpwc_placeholder"><?php esc_html_e("Field Placeholder","wpwc-registration"); ?></label></th>
												<td><input type="text" name="wpwc_fields_registration_form[<?php echo $key ?>][placeholder]" id="wpwc_placeholder" class="regular-text" value="<?php echo (isset($data[$key]['placeholder'])) ? esc_attr($data[$key]['placeholder']) : esc_attr($value['placeholder']); ?>"></td>
											</tr>
										<?php endif;
										 if(isset($value['description'])): ?>
											<tr>
												<th><label for="wpwc_description"><?php esc_html_e("Description","wpwc-registration"); ?></label></th>
												<td><input type="text" name="wpwc_fields_registration_form[<?php echo $key ?>][description]" id="wpwc_description" class="regular-text" value="<?php echo (isset($data[$key]['description'])) ? esc_attr($data[$key]['description']) : esc_attr($value['description']); ?>"></td>
											</tr>
										<?php endif;
										 if(isset($value['required'])): ?>
											<tr>
												<th><label for="wpwc_required"><?php esc_html_e("Field Required?","wpwc-registration"); ?></label></th>
												<td><input type="checkbox" name="wpwc_fields_registration_form[<?php echo $key ?>][required]" id="wpwc_required" value="yes" <?php echo (isset($data[$key]['required']) && $data[$key]['required']=='yes') ? 'checked' : ''; ?>></td>
											</tr>
										<?php endif;
										 if(isset($value['class'])): ?>
											<tr>
												<th><label for="wpwc_size"><?php esc_html_e("Field Size","wpwc-registration"); ?></label></th>
												<td>
													<select name="wpwc_fields_registration_form[<?php echo $key ?>][class][]" id="wpwc_size">
														<option value="wpwc-full" <?php echo (isset($data[$key]['class']) && is_array($data[$key]['class']) && in_array('wpwc-full',$data[$key]['class'])) ? 'selected' : ''; ?>><?php esc_html_e('Full Width','wpwc-registration') ?></option>
														<option value="wpwc-half" <?php echo (isset($data[$key]['class']) && is_array($data[$key]['class']) && in_array('wpwc-half',$data[$key]['class'])) ? 'selected' : ''; ?>><?php esc_html_e('Half Width','wpwc-registration') ?></option>
													</select>
												</td>
											</tr>
										<?php endif; ?>
										</tbody>
									</table>
								</div>
							</div>
						</div>
					<?php $i++; } ?>
						</div>
					<?php submit_button(); ?>
				</form>
			</div>
			<?php
		}
	    public function notification_settings(){
	    	?>
    	<div class="wrap">
            <form method="post" action="options.php">
                <?php settings_errors(); ?>
                <?php settings_fields('wpwc-notification-settings-group'); ?>
                <?php do_settings_sections('wpwc-notification-settings-group'); ?>
                 <table class="form-table">
                    <tr valign="top">
						<th><label for="wpwc_enable_grant_role_notification">
                        	<?php esc_html_e("Role Grant Notification for user.","wpwc-registration"); ?></label>
                        </th>
                        <td><?php $value=get_option('wpwc_enable_grant_role_notification'); ?>
                        	<input type="checkbox" name="wpwc_enable_grant_role_notification" value="yes" id="wpwc_enable_grant_role_notification" <?php echo ($value=='yes') ? 'checked': ''; ?>>
                        	<span><?php esc_html_e("Enable user role grant notification for user.","wpwc-registration"); ?></span>
                        </td>
                    </tr>
					<tr>
                        <th><label for="wpwc_grant_role_notification_subject">
                        	<?php esc_html_e("Role Grant Notification Subject","wpwc-registration"); ?></label>
                        </th>
                        <td><?php $value=get_option('wpwc_grant_role_notification_subject'); ?>
                        	<input type="text" name="wpwc_grant_role_notification_subject" value="<?php echo !empty($value) ? esc_attr($value) : ''; ?>" id="wpwc_grant_role_notification_subject" class="regular-text">
                        	<p><?php esc_html_e("User role grant email notification subject.","wpwc-registration"); ?></p>
                        </td>
                    </tr>
					<tr>
                        <th><label for="wpwc_grant_role_notification_body">
                        	<?php esc_html_e("Role Grant Notification Message","wpwc-registration"); ?></label>
                        </th>
                        <td><?php $value=get_option('wpwc_grant_role_notification_body'); ?>
							<?php wp_editor( $value, 'wpwc_grant_role_notification_body', array('textarea_rows'=>3) ) ?>
                        	<p><?php esc_html_e("User role grant email notification body.","wpwc-registration"); ?></p>
                        </td>
                    </tr>
					<tr>
						<th><label for="wpwc_enable_access_allow_notification">
                        	<?php esc_html_e("Login Active Notification","wpwc-registration"); ?></label>
                        </th>
                        <td><?php $value=get_option('wpwc_enable_access_allow_notification'); ?>
                        	<input type="checkbox" name="wpwc_enable_access_allow_notification" value="yes" id="wpwc_enable_access_allow_notification" <?php echo ($value=='yes') ? 'checked': ''; ?>>
                        	<span><?php esc_html_e("Enable user login active access notification for users.","wpwc-registration"); ?></span>
                        </td>
                    </tr>
					<tr>
                        <th><label for="wpwc_access_allow_notification_subject">
                        	<?php esc_html_e("Login Active Notification Subject","wpwc-registration"); ?></label>
                        </th>
                        <td><?php $value=get_option('wpwc_access_allow_notification_subject'); ?>
                        	<input type="text" name="wpwc_access_allow_notification_subject" value="<?php echo !empty($value) ? esc_attr($value) : ''; ?>" id="wpwc_access_allow_notification_subject" class="regular-text">
                        	<p><?php esc_html_e("User login active access notification subject.","wpwc-registration"); ?></p>
                        </td>
                    </tr>
					<tr>
                        <th><label for="wpwc_access_allow_notification_body">
                        	<?php esc_html_e("Login Active Notification Message","wpwc-registration"); ?></label>
                        </th>
                        <td><?php $value=get_option('wpwc_access_allow_notification_body'); ?>
							<?php wp_editor( $value, 'wpwc_access_allow_notification_body', array('textarea_rows'=>3) ) ?>
                        	<p><?php esc_html_e("User login active access notification body.","wpwc-registration"); ?></p>
                        </td>
                    </tr>
					<tr>
						<th><label for="wpwc_enable_access_block_notification">
                        	<?php esc_html_e("Login Disable Notification","wpwc-registration"); ?></label>
                        </th>
                        <td><?php $value=get_option('wpwc_enable_access_block_notification'); ?>
                        	<input type="checkbox" name="wpwc_enable_access_block_notification" value="yes" id="wpwc_enable_access_block_notification" <?php echo ($value=='yes') ? 'checked': ''; ?>>
                        	<span><?php esc_html_e("Enable user login disable notification for users.","wpwc-registration"); ?></span>
                        </td>
                    </tr>
					<tr>
                        <th><label for="wpwc_access_block_notification_subject">
                        	<?php esc_html_e("Login Disable Notification Subject","wpwc-registration"); ?></label>
                        </th>
                        <td><?php $value=get_option('wpwc_access_block_notification_subject'); ?>
                        	<input type="text" name="wpwc_access_block_notification_subject" value="<?php echo !empty($value) ? esc_attr($value) : ''; ?>" id="wpwc_access_block_notification_subject" class="regular-text">
                        	<p><?php esc_html_e("User login disable email notification subject.","wpwc-registration"); ?></p>
                        </td>
                    </tr>
					<tr>
                        <th><label for="wpwc_access_block_notification_body">
                        	<?php esc_html_e("Login Disable Notification Message","wpwc-registration"); ?></label>
                        </th>
                        <td><?php $value=get_option('wpwc_access_block_notification_body'); ?>
							<?php wp_editor( $value, 'wpwc_access_block_notification_body', array('textarea_rows'=>3) ) ?>
                        	<p><?php esc_html_e("User login disable email notification body.","wpwc-registration"); ?></p>
                        </td>
                    </tr>
                </table>
                <?php submit_button(); ?>
            </form>
        </div>
        <?php
	    }
	}
	new WPWC_User_Registration_Settings();
}