<?php
if (!defined('ABSPATH')) {
    exit; 
} 
if(!class_exists('WPWC_Custom_Fields_Settings')){
	class WPWC_Custom_Fields_Settings{
		public function __construct(){
		    add_action('init', array($this, 'wpwc_register_fields'));
		    add_action('add_meta_boxes', array($this,'wpwc_add_custom_box'));
		    add_filter('manage_wpwc-custom-fields_posts_columns', array($this,'wpwc_custom_columns'),10,1);
			add_action('manage_wpwc-custom-fields_posts_custom_column', array($this,'wpwc_manage_column'), 10, 2 );
			add_action('save_post_wpwc-custom-fields', array($this,'wpwc_save_custom_fields'), 90, 1 );
			add_filter('wp_insert_post_data', array($this,'wpwc_menu_order'),99, 1 );
			add_action('trashed_post', array($this,'wpwc_post_trashed'), 10, 1 );
			add_filter('post_row_actions', array($this,'wpwc_quick_action_link'), 10, 2);
			add_action('show_user_profile', array($this,'wpwc_extra_user_fields'),10,1);
			add_action('edit_user_profile', array($this,'wpwc_extra_user_fields'),10,1);
			add_action('personal_options_update', array($this,'wpwc_save_extra_author_fields') );
			add_action('edit_user_profile_update', array($this,'wpwc_save_extra_author_fields') );
		}
		public function wpwc_register_fields(){
		    $labels = array(
				'name'               => esc_html_x('Custom Registration Fields', 'Custom Fields general name', 'wpwc-registration' ),
				'singular_name'      => esc_html_x('Custom Registration Field', 'Custom Field singular name', 'wpwc-registration' ),
				'menu_name'          => esc_html_x('Custom Registration Fields', 'Rule Sets admin menu', 'wpwc-registration' ),
				'name_admin_bar'     => esc_html_x('Custom Registration Field', 'add new on admin bar', 'wpwc-registration' ),
				'add_new'            => esc_html_x('Add New', 'Custom Field', 'wpwc-registration' ),
				'add_new_item'       => esc_html__('Add New Custom Field', 'wpwc-registration' ),
				'new_item'           => esc_html__('New Custom Registration Field', 'wpwc-registration' ),
				'edit_item'          => esc_html__('Edit Custom Registration Field', 'wpwc-registration' ),
				'view_item'          => esc_html__('View Custom Registration Field', 'wpwc-registration' ),
				'all_items'          => esc_html__('All Custom Registration Fields', 'wpwc-registration' ),
				'search_items'       => esc_html__('Search Custom Registration Fields', 'wpwc-registration' ),
				'parent_item_colon'  => esc_html__('Parent Custom Registration Fields:', 'wpwc-registration' ),
				'not_found'          => esc_html__('No Custom Registration Fields found.', 'wpwc-registration' ),
				'not_found_in_trash' => esc_html__('No Custom Registration Fields found in Trash.', 'wpwc-registration' )
			);
			$args = array(
				'labels'             => $labels,
		        'description'        => esc_html__('WooCommerce Custom Registration Fields.', 'wpwc-registration' ),
				'public'             => false,
				'publicly_queryable' => false,
				'show_ui'            => true,
				'show_in_menu'       => false,
				'query_var'          => true,
				'rewrite'            => false,
				'capability_type'    => 'post',
				'has_archive'        => false,
				'hierarchical'       => false,
				'menu_position'      => null,
				'supports'           => array('title')
			);
			register_post_type('wpwc-custom-fields', $args );
		}
		public function wpwc_custom_columns($columns){
			unset( $columns['date'] );
		    $columns['wpwc_field_type'] = esc_html__('Field Type', 'wpwc-registration');
		    $columns['wpwc_status'] = esc_html__('Status', 'wpwc-registration');
		    $columns['wpwc_priority'] = esc_html__('Field Priority', 'wpwc-registration');
		    $columns['date'] = esc_html__('Date', 'wpwc-registration');
		    return $columns;
		}
		public function wpwc_manage_column($column, $post_id){
			switch ( $column ) {
		        case 'wpwc_field_type':
		        	$type = get_post_meta($post_id,'wpwc_custom_field_type',true);
		        	echo esc_html($type);
		            break;
		        case 'wpwc_status':
		           $status = get_post_meta($post_id,'wpwc_custom_field_status',true);
		            echo esc_html($status);
		            break; 
		        case 'wpwc_priority':
		        	$type = get_post_meta($post_id,'wpwc_custom_field_priority',true);
		        	echo esc_html($type);
		            break;
		    }
		}
		public function wpwc_add_custom_box(){
		    add_meta_box( 'wpwc-custom-registration-fields', esc_html__('Custom Registration Fields','wpwc-registration'), array($this,'wpwc_meta_box_settings') , 'wpwc-custom-fields', 'advanced', 'high');
		}
		private function wpwc_fields(){
			return array(
				'text'		=> esc_html__('Text', 'wpwc-registration'),
				'number'	=> esc_html__('Number', 'wpwc-registration'),
				'email'		=> esc_html__('Email', 'wpwc-registration'),
				'textarea'	=> esc_html__('Textarea', 'wpwc-registration'),
				'password'	=> esc_html__('Password', 'wpwc-registration'),
				'hidden'	=> esc_html__('Hidden', 'wpwc-registration'),
				'date'		=> esc_html__('Date', 'wpwc-registration'),
				'tel'		=> esc_html__('Tel', 'wpwc-registration'),
				'select'    => esc_html__('Select','wpwc-registration'),
				'radio'    	=> esc_html__('Radio','wpwc-registration'),
				'checkbox' 	=> esc_html__('Checkbox','wpwc-registration'),
				'file' 		=> esc_html__('File','wpwc-registration'),
				'texthtml'    => esc_html__('Text/HTML','wc-crf')
			);
		}
		public function wpwc_meta_box_settings(){
		    global $post;
			global $woocommerce;
			$post_id=$post->ID;
			wp_nonce_field('wpwc_custom_fields_nonce','wpwc_custom_fields_nonce'); ?>
			<div class="dpd_dynamic_pricing_discountss">
				<table class="form-table">
					<tr>
						<th>
							<label for="wpwc_custom_field_type"><?php esc_html_e('Custom Registration Field Type','wpwc-registration'); ?></label>
						</th>
						<td><?php $field_type=get_post_meta($post_id,'wpwc_custom_field_type',true); ?>
							<select name="wpwc_custom_field_type" id="wpwc_custom_field_type" class="regular-text">
								<?php foreach ($this->wpwc_fields() as $key => $field) {
									echo '<option value="'.esc_attr($key).'" '.selected($key,$field_type).'>'.esc_attr($field).'</option>';
								} ?>
							</select>
						</td>
					</tr>
					<tr class="wpwc_custom_field_label">
						<th>
							<label for="wpwc_custom_field_label"><?php esc_html_e('Field Label','wpwc-registration'); ?></label>
						</th>
						<td><?php $value=get_post_meta($post_id,'wpwc_custom_field_label',true); ?>
							<input type="text" name="wpwc_custom_field_label" id="wpwc_custom_field_label" value="<?php esc_attr_e($value); ?>" class="regular-text">
						</td>
					</tr>
					<tr class="wpwc_custom_field_required">
						<th>
							<label for="wpwc_custom_field_required"><?php esc_html_e('Field Required?','wpwc-registration'); ?></label>
						</th>
						<td><?php $value=get_post_meta($post_id,'wpwc_custom_field_required',true); ?>
							<input type="checkbox" name="wpwc_custom_field_required" id="wpwc_custom_field_required" value="yes" <?php echo checked('yes',$value); ?>><span><i><?php esc_html_e('Enable field required.', 'wpwc-registration'); ?></i></span>
						</td>
					</tr>
					<tr class="wpwc_custom_field_size">
						<th>
							<label for="wpwc_custom_field_size"><?php esc_html_e('Field Size','wpwc-registration'); ?></label>
						</th>
						<td><?php $value=get_post_meta($post_id,'wpwc_custom_field_size',true); ?>
							<select name="wpwc_custom_field_size" id="wpwc_custom_field_size" class="regular-text">
								<option value="wpwc-full" <?php echo selected('wpwc-full',$value); ?>><?php esc_html_e('Full Width', 'wpwc-registration'); ?></option>
								<option value="wpwc-half" <?php echo selected('wpwc-half',$value); ?>><?php esc_html_e('Half Width', 'wpwc-registration'); ?></option>
							</select>
						</td>
					</tr>
					<tr>
						<th>
							<label for="wpwc_custom_field_description"><?php esc_html_e('Field Description','wpwc-registration'); ?></label>
						</th>
						<td><?php $value=get_post_meta($post_id,'wpwc_custom_field_description',true); ?>
							<input type="text" name="wpwc_custom_field_description" id="wpwc_custom_field_description" class="regular-text" value="<?php echo wp_kses_post($value); ?>">
						</td>
					</tr>
					<tr class="wpwc_field_multi_options" <?php echo ($field_type=='select' || $field_type=='radio') ? '' : 'style="display:none;"' ?>>
						<th><?php esc_html_e('Field Options','wpwc-registration'); ?></th>
						<td>
							<div class="wpwc_field_options">
							<?php $options=get_post_meta($post_id,'wpwc_field_options',true); 
								if(!empty($options)){
									$i=0;
									foreach ($options as $option) { 
										$style=($i==0) ? 'style=display:none;' : ''; ?>
										<p>
											<span class="wpwc_value"><input type="text" value="<?php esc_attr_e($option['value']); ?>" name="wpwc_field_options[<?php echo $i; ?>][value]" placeholder="<?php esc_html_e('Value', 'wpwc-registration'); ?>"></span>
											<span class="wpwc_label"><input type="text" value="<?php esc_attr_e($option['label']); ?>" name="wpwc_field_options[<?php echo $i; ?>][label]" placeholder="<?php esc_html_e('Label', 'wpwc-registration'); ?>"></span>
											<span class="wpwc_actions">
												<a href="#" class="wpwc_remove" <?php echo $style; ?>><span class="dashicons dashicons-dismiss"></span></a>
												<a href="#" class="wpwc_add"><span class="dashicons dashicons-plus-alt"></span></a>
											</span>
										</p>
								<?php $i++; }
								}else{ ?>
								<p>
									<span class="wpwc_value"><input type="text" value="" name="wpwc_field_options[0][value]" placeholder="<?php esc_html_e('Value', 'wpwc-registration'); ?>"></span>
									<span class="wpwc_label"><input type="text" value="" name="wpwc_field_options[0][label]" placeholder="<?php esc_html_e('Label', 'wpwc-registration'); ?>"></span>
									<span class="wpwc_actions">
										<a href="#" class="wpwc_remove" style="display: none;"><span class="dashicons dashicons-dismiss"></span></a>
										<a href="#" class="wpwc_add"><span class="dashicons dashicons-plus-alt"></span></a>
									</span>
								</p>
							<?php } ?>
							</div>
						</td>
					</tr>
					<tr>
						<th>
							<label for="wpwc_custom_field_priority"><?php esc_html_e('Field Priority','wpwc-registration'); ?></label>
						</th>
						<td><?php $value=get_post_meta($post_id,'wpwc_custom_field_priority',true); ?>
							<input type="number" name="wpwc_custom_field_priority" id="wpwc_custom_field_priority" class="regular-text" value="<?php esc_attr_e($value); ?>">
						</td>
					</tr>
				</table>
			</div>
			<?php
		}
		public function wpwc_save_custom_fields($post_id){
			//if doing an auto save
		    if(defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
		    // if our nonce isn't there, or we can't verify it
		   if(!isset($_POST['wpwc_custom_fields_nonce'] ) || !wp_verify_nonce($_POST['wpwc_custom_fields_nonce'],'wpwc_custom_fields_nonce')) return;
		    // if current user can't edit this post
		    if(!current_user_can('edit_post')) return;
		    $fields=array();
		    $fields['ID']=$post_id;
		    if(isset($_POST['wpwc_custom_field_type'])){
		    	$type=sanitize_text_field($_POST['wpwc_custom_field_type']);
		    	$fields['type']=$type;
		    	update_post_meta( $post_id,'wpwc_custom_field_type',$type);
			}
			if(isset($_POST['wpwc_custom_field_type']) && $_POST['wpwc_custom_field_type']=='texthtml' && isset($_POST['wpwc_custom_field_description'])){
				$fields['text_html']=wp_kses_post($_POST['wpwc_custom_field_description']);
				update_post_meta( $post_id,'wpwc_html_text_area',wp_kses_post($_POST['wpwc_custom_field_description']));
			}else{
				$fields['text_html']='';
				update_post_meta( $post_id,'wpwc_html_text_area','');
			}
		    if(isset($_POST['wpwc_custom_field_label'])){
		    	$label=sanitize_text_field($_POST['wpwc_custom_field_label']);
		    	$fields['label']=$label;
		    	update_post_meta( $post_id,'wpwc_custom_field_label',$label);
		    }
		    if(isset($_POST['wpwc_custom_field_required'])){
		    	$fields['required']=true;
		    	update_post_meta( $post_id,'wpwc_custom_field_required','yes');
		    }else{
		    	$fields['required']=false;
		    	update_post_meta( $post_id,'wpwc_custom_field_required','no');
		    }
		    if(isset($_POST['wpwc_custom_field_size'])){
		    	$size=sanitize_text_field($_POST['wpwc_custom_field_size']);
		    	$fields['class']=array($size);
		    	update_post_meta( $post_id,'wpwc_custom_field_size',$size);
		    }
		    if(!empty($_POST['wpwc_field_options']) && ($_POST['wpwc_custom_field_type']=='radio' || $_POST['wpwc_custom_field_type']=='select')){
		    	$options=wc_clean($_POST['wpwc_field_options']);
		    	$options_arr=array();
		    	foreach ($_POST['wpwc_field_options'] as $key => $option) { 
		    		$options_arr=array_merge($options_arr,array($option['value'] => $option['label']));
		    	}
		    	$fields['options']=$options_arr;
		    	update_post_meta($post_id,'wpwc_field_options',$options);
		    }else{
		    	$options=array();
		    	$fields['options']=$options;
		    	update_post_meta($post_id,'wpwc_field_options',$options);
		    }
		    if(isset($_POST['wpwc_custom_field_priority'])){
		    	$priority=sanitize_text_field($_POST['wpwc_custom_field_priority']);
		    	$fields['priority']=$priority;
		    	update_post_meta( $post_id,'wpwc_custom_field_priority',$priority);
		    }
		    if(isset($_POST['wpwc_custom_field_description'])){
		        if(isset($_POST['wpwc_custom_field_type']) && $_POST['wpwc_custom_field_type']=='texthtml'){
		            $description=wp_kses_post($_POST['wpwc_custom_field_description']);
		        }else{
		    	    $description=sanitize_text_field($_POST['wpwc_custom_field_description']);
		        }
		    	$fields['description']=$description;
		    	update_post_meta( $post_id,'wpwc_custom_field_description',$description);
		    }
		    update_post_meta($post_id,'wpwc_custom_registration_fields',$fields);
		    $this->wpwc_refresh_fields();
		    return $post_id;
		}
		public function wpwc_menu_order($data){
			if($data['post_type'] == 'wpwc-custom-fields' && isset($_POST['wpwc_custom_field_priority'])) { 
			    $num = (int) sanitize_text_field($_POST['wpwc_custom_field_priority']);
			    $data['menu_order'] = $num; 
			}
			return $data;
		}
		public function wpwc_post_trashed($post_id){
			if(get_post_type($post_id)=='wpwc-custom-fields'){
				$this->wpwc_refresh_fields();
			}
		}
		public function wpwc_quick_action_link($actions, $post){
			if($post->post_type=='wpwc-custom-fields')
				unset($actions['inline hide-if-no-js']);
			return $actions;
		}
		public function wpwc_refresh_fields(){
			$args = array(
				'posts_per_page'=> -1,
				'post_type'     => 'wpwc-custom-fields',
				'post_status'   => 'publish',
				'orderby' 		=> 'menu_order', 
				'order'			=> 'ASC',
				'fields'        => 'ids'
				);
			$field_ids = get_posts($args);
			$fields=array();
			if(!empty($field_ids)){
				foreach ($field_ids as $field_id) {
					$fields[$field_id]=get_post_meta($field_id,'wpwc_custom_registration_fields',true);
				}
			}
			update_option('wpwc_custom_registration_fields',$fields);
		}
		public function wpwc_extra_user_fields($user){ 
			$fields=get_option('wpwc_custom_registration_fields');
			if(!empty($fields)){ ?>
				<h3><?php esc_html_e('Custom Registration Fields', 'wpwc-registration'); ?></h3>
			    <table class="form-table">
			    	<?php foreach ($fields as $key => $field) { 
						if(!empty($field['type']) && $field['type']=='texthtml') {
							echo '<tr><td colspan="2">'.wp_kses_post($field['description']).'</td></tr>';
						}else{ ?>
			        <tr>
			            <th><label for="wpwc_custom_registration_field_'<?php esc_attr_e($key); ?>"><?php esc_html_e($field['label']); ?></label></th>
			            <td><?php if(!empty($field['type']) && $field['type']=='textarea'){ ?>
				            	<textarea name="wpwc_custom_registration_field_<?php esc_attr_e($key); ?>" id="wpwc_custom_registration_field_<?php esc_attr_e($key); ?>" class="regular-text"><?php echo esc_html( get_the_author_meta('wpwc_custom_registration_field_'.esc_attr($key), $user->ID ) ); ?></textarea>
				                <p class="description"><?php esc_html_e($field['description']); ?></p>
				            <?php }elseif(!empty($field['type']) && $field['type']=='select'){ ?>
				            	<select name="wpwc_custom_registration_field_<?php esc_attr_e($key); ?>" id="wpwc_custom_registration_field_<?php esc_attr_e($key); ?>">
				            		<?php if(!empty($field['options'])){
				            			$selVal=get_the_author_meta('wpwc_custom_registration_field_'.esc_attr($key), $user->ID );
				            			foreach ($field['options'] as $opkey => $option) {
				            				echo '<option value="'.esc_attr($opkey).'" '.selected($opkey,$selVal).'>'.esc_html($option).'</option>';
				            			}
				            		} ?>
				            	</select>
				            	<p class="description"><?php esc_html_e($field['description']); ?></p>
				            <?php }elseif(!empty($field['type']) && $field['type']=='radio'){ 
				            	if(!empty($field['options'])){
			            			$radVal=get_the_author_meta('wpwc_custom_registration_field_'.esc_attr($key), $user->ID );
			            			foreach ($field['options'] as $opkey => $option) {
			            				echo '<p><label><input type="radio" name="wpwc_custom_registration_field_'.esc_attr($key).' value="'.esc_attr($opkey).'" '.checked($opkey,$radVal).'> '.esc_html($option).'</label></p>';
			            			}
			            		} ?>
				            	<p class="description"><?php esc_html_e($field['description']); ?></p>
				            <?php }elseif(!empty($field['type']) && $field['type']=='checkbox'){ 
			            			$chVal=get_the_author_meta('wpwc_custom_registration_field_'.esc_attr($key), $user->ID );
			            			echo '<p><label><input type="checkbox" name="wpwc_custom_registration_field_'.esc_attr($key).' value="1" '.checked(1,$chVal,false).'> '.esc_html($field['label']).'</label></p>';
			            		?>
				            	<p class="description"><?php esc_html_e($field['description']); ?></p>
							<?php }elseif(!empty($field['type']) && $field['type']=='file'){ 
								$file=get_the_author_meta('wpwc_custom_registration_field_'.esc_attr($key), $user->ID );
								$file=wp_get_attachment_url($file);  
								$file=!empty($file) ? $file : WPWC_REG_URL.'assets/img/no-pic.jpeg'; ?>
								<p><img src="<?php echo esc_url($file); ?>" width="100" height="100" class="wpwc_user_file"></p>
								<p><button class="button-primary wpwc_upload_profile_file"><?php esc_html_e('Upload','wpwc-registration'); ?></button></p>
								<input type="hidden" class="wpwc_profile_picture" name="wpwc_custom_registration_field_<?php esc_attr_e($key); ?>" value="">
							<?php }else{ ?>
				                <input type="<?php esc_attr_e($field['type']); ?>" name="wpwc_custom_registration_field_<?php esc_attr_e($key); ?>" id="wpwc_custom_registration_field_<?php esc_attr_e($key); ?>" class="regular-text" value="<?php echo esc_attr( get_the_author_meta('wpwc_custom_registration_field_'.esc_attr($key), $user->ID ) ); ?>" />
				                <p class="description"><?php esc_html_e($field['description']); ?></p>
				            <?php } ?>
			            </td>
			        </tr>
				    <?php } } ?>
			    </table>
			    <?php
			}
		}
		public function wpwc_save_extra_author_fields($user_id){
			if ( ! current_user_can( 'edit_user', $user_id ) )
		        return false;
		    $fields=get_option('wpwc_custom_registration_fields');
			if(!empty($fields)){
				foreach ($fields as $key => $field) {
					if(isset($_POST['wpwc_custom_registration_field_'.esc_attr($key)])){
						if($field['type']=='file' && !empty($_POST['wpwc_custom_registration_field_'.esc_attr($key)])){
							update_user_meta( $user_id, 'wpwc_custom_registration_field_'.esc_attr($key), sanitize_text_field($_POST['wpwc_custom_registration_field_'.esc_attr($key)]) );
						}else{
			    			update_user_meta( $user_id, 'wpwc_custom_registration_field_'.esc_attr($key), sanitize_text_field($_POST['wpwc_custom_registration_field_'.esc_attr($key)]) );
						}
					}
				}
			}
		}
	}
	new WPWC_Custom_Fields_Settings();
}