<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
} //!defined('ABSPATH')
if(!class_exists('WPWC_User_Registration_Backend')){
	class WPWC_User_Registration_Backend{
		public function __construct(){
			add_action('admin_menu', array($this, 'add_menu_page'));
			add_action('init', array($this,'create_role_taxonomies'),0 );
			add_action('admin_head', array($this, 'taxonomy_menu_highlight') );
			add_action('created_wpwc-user-role', array($this, 'set_term_to_user_role'),10,2);
	      	add_action("delete_wpwc-user-role",  array($this, 'remove_term_and_user_role'),10,3 );
	      	add_action("edit_wpwc-user-role", array($this, 'edit_term_and_user_role') ,10,2);
	      	add_filter('manage_users_columns', array($this,'modify_user_table'));
	      	add_filter('manage_users_custom_column', array($this,'modify_user_table_row'), 10, 3 );
	      	add_filter('bulk_actions-users', array($this, 'user_bulk_actions'));
			add_filter('handle_bulk_actions-users', array($this,'handle_user_bulk_actions'), 10, 3 );
			add_action('restrict_manage_users', array($this,'add_custom_filter'));
			add_filter('pre_get_users', array($this,'filter_users_by_status' ),20,1);
			add_action('admin_enqueue_scripts', array($this, 'enqueue_scripts'));
		}
		public function add_menu_page(){
    		add_menu_page(esc_html__('User Registration','wpwc-registration'), esc_html__('User Registration','wpwc-registration'), 'manage_options', 'wpwc-user-registration', array($this, 'user_registration'),'dashicons-groups',57);
    		add_submenu_page('wpwc-user-registration', esc_html__('Settings','wpwc-registration'), esc_html__('Settings','wpwc-registration'), 'manage_options' , 'wpwc-user-registration' );
    		add_submenu_page('wpwc-user-registration', esc_html__('User Roles','wpwc-registration'), esc_html__('User Roles','wpwc-registration'), 'manage_options' , 'edit-tags.php?taxonomy=wpwc-user-role' );
    		add_submenu_page('wpwc-user-registration', esc_html__('Custom Registration Fields','wpwc-registration'), esc_html__('Custom Registration Fields','wpwc-registration'), 'manage_options' , admin_url('edit.php?post_type=wpwc-custom-fields') );
    		register_setting('wpwc-user-general-settings-group', 'wpwc_enable_user_authentication');
            register_setting('wpwc-user-general-settings-group', 'wpwc_account_disable_error');
            register_setting('wpwc-user-general-settings-group', 'wpwc_new_user_reg_authentication');
            register_setting('wpwc-user-general-settings-group', 'wpwc_default_fields_position');
            register_setting('wpwc-user-general-settings-group', 'wpwc_custom_fields_position');
            register_setting('wpwc-registration-settings-group', 'wpwc_enable_user_role_field');
            register_setting('wpwc-registration-settings-group', 'wpwc_user_role_field_label');
            register_setting('wpwc-registration-settings-group', 'wpwc_user_role_approve_status');
            register_setting('wpwc-registration-settings-group', 'wpwc_user_role_field_required');
            register_setting('wpwc-registration-settings-group', 'wpwc_user_role_dropdown_options');
			register_setting('wpwc-notification-settings-group', 'wpwc_enable_grant_role_notification');
			register_setting('wpwc-notification-settings-group', 'wpwc_grant_role_notification_subject');
			register_setting('wpwc-notification-settings-group', 'wpwc_grant_role_notification_body');
			register_setting('wpwc-notification-settings-group', 'wpwc_enable_access_allow_notification');
			register_setting('wpwc-notification-settings-group', 'wpwc_access_allow_notification_subject');
			register_setting('wpwc-notification-settings-group', 'wpwc_access_allow_notification_body');
			register_setting('wpwc-notification-settings-group', 'wpwc_enable_access_block_notification');
			register_setting('wpwc-notification-settings-group', 'wpwc_access_block_notification_subject');
			register_setting('wpwc-notification-settings-group', 'wpwc_access_block_notification_body');
			register_setting( 'wpwc-registration-fields-group', 'wpwc_fields_registration_form' );
		}
		public function user_registration(){
			require_once WPWC_REG_DIR.'/includes/class-wpwc-settings.php';
		}
		public function create_role_taxonomies(){
    		// Add new taxonomy, make it hierarchical (like categories)
			$labels = array(
				'name'              => esc_html__( 'Roles', 'wpwc-registration' ),
				'singular_name'     => esc_html__( 'Role', 'wpwc-registration' ),
				'search_items'      => esc_html__( 'Search Roles', 'wpwc-registration' ),
				'all_items'         => esc_html__( 'All Roles', 'wpwc-registration' ),
				'parent_item'       => esc_html__( 'Parent Role', 'wpwc-registration' ),
				'edit_item'         => esc_html__( 'Edit Role', 'wpwc-registration' ),
				'update_item'       => esc_html__( 'Update Role', 'wpwc-registration' ),
				'add_new_item'      => esc_html__( 'Add New Role', 'wpwc-registration' ),
				'new_item_name'     => esc_html__( 'New Role Name', 'wpwc-registration' ),
				'menu_name'         => esc_html__( 'Role', 'wpwc-registration' ),
			);
			$args = array(
				'hierarchical'      => false,
				'labels'            => $labels,
				'show_ui'           => true,
				'show_admin_column' => true,
				'query_var'         => true,
				'rewrite'           => array( 'slug' => 'wc-user-role' ),
			);
			register_taxonomy( 'wpwc-user-role','',$args );
    	}
    	public function set_term_to_user_role( $term_id, $tt_id){
        	$term=get_term($term_id,'wpwc-user-role');
        	if(!wp_roles()->is_role( $term->slug)){
    	    	add_role( $term->slug, $term->name, array( 'read' => true, 'level_0' => true ) );
    	    }
        }
        public function remove_term_and_user_role($term,$tt_id,$deleted_term){
        	$termObj=get_term($deleted_term,'wpwc-user-role');
        	if(wp_roles()->is_role( $termObj->slug)){
    	    	remove_role($termObj->slug);
    	    }
        }
    	public function taxonomy_menu_highlight(){
            global $parent_file, $submenu_file;
            if ($submenu_file =='edit.php?post_type=wpwc-custom-fields') :
                $parent_file = 'wpwc-user-registration';
                $submenu_file = 'edit.php?post_type=wpwc-custom-fields';
            endif;
            if ($submenu_file =='post-new.php?post_type=wpwc-custom-fields') :
                $parent_file = 'wpwc-user-registration';
                $submenu_file = 'edit.php?post_type=wpwc-custom-fields';
            endif;
            if ($submenu_file =='edit-tags.php?taxonomy=wpwc-user-role') :
                $parent_file = 'wpwc-user-registration';
                $submenu_file = 'edit-tags.php?taxonomy=wpwc-user-role';
            endif;
        }
        public function edit_term_and_user_role($term_id,$tt_id ){
        	$termObj=get_term($term_id,'wpwc-user-role');
        	$new_name=isset($_POST['name']) ? wc_clean($_POST['name']) : '';
        	$new_slug=isset($_POST['slug']) ? wc_clean($_POST['slug']) : '';
        	if($new_slug!=$termObj->slug){
        		if(empty($new_slug)){
        			$new_slug=sanitize_title($new_name);
        		}
        		if(wp_roles()->is_role( $termObj->slug)){
    		    	remove_role($termObj->slug);
    		    }
    		    if(!wp_roles()->is_role( $new_slug)){
    		    	add_role( $new_slug, $new_name, array( 'read' => true, 'level_0' => true ) );
    		    }
    	    	$args = array(
    			    'role'    => $termObj->slug,
    			);
    			$users = get_users( $args );
    			if(!empty($users)){
    				foreach ( $users as $user ) {
    			        $user = new WP_User( $user->ID );
    			        // Remove current subscriber role
    			        $user->remove_role( $termObj->slug );
    			        $user->remove_cap( $termObj->slug );
    			        // Upgrade to editor role
    			        $user->add_role( $new_slug );
    			        $user->add_cap( $new_slug );
    			        wp_cache_delete($user->ID, 'users');
    			    }
    			}
    		}
        }
        public function modify_user_table($column){
        	$column['wpwc-status'] = esc_html__("Status","wpwc-registration");
        	$column['wpwc-request'] = esc_html__("Role Request","wpwc-registration");
		    return $column;
        }
        public function modify_user_table_row($val, $column_name, $user_id){
        	switch ($column_name) {
		        case 'wpwc-status' :
		            if(get_user_meta($user_id,'wpwc_user_auth_status',true)=='disabled'){
		            	return esc_html__("Disable","wpwc-registration");
		            }else{
		            	return esc_html__("Active","wpwc-registration");
		            }
		            break;
				case 'wpwc-request' :
					global $wp_roles;
					$roles = $wp_roles->get_names();
		        	$role=get_user_meta($user_id,'wpwc_user_requested_role',true);
		            return isset($roles[$role]) ? $roles[$role] : '';
		            break;
		        default:
		    }
		    return $val;
        }
        public function user_bulk_actions($actions){
        	$actions['wpwc-enable']=esc_html__("Enable Account","wpwc-registration");
        	$actions['wpwc-disable']=esc_html__("Disable Account","wpwc-registration");
        	$actions['wpwc-grant-role']=esc_html__("Grant Role","wpwc-registration");
	        return $actions;
        }
        public function handle_user_bulk_actions($redirect_to, $doaction, $user_ids){
        	if ( $doaction == 'wpwc-enable') {
		       if(!empty($user_ids)){
			       	$user=get_current_user_id();
			       	$user_ids=array_diff($user_ids, array($user));
			       	foreach ($user_ids as $key => $user_id) {
						   update_user_meta($user_id,"wpwc_user_auth_status","active");
						   do_action('wpwc_user_auth_status_changed', $user_id,'active');
			       	}
		       }
		    }elseif($doaction =='wpwc-disable'){
		    	if(!empty($user_ids)){
			       	$user=get_current_user_id();
			       	$user_ids=array_diff($user_ids, array($user));
			       	foreach ($user_ids as $key => $user_id) {
						   update_user_meta($user_id,"wpwc_user_auth_status","disabled");
						   do_action('wpwc_user_auth_status_changed', $user_id,'disabled');
			       	}
		       }
		    }elseif($doaction =='wpwc-grant-role'){
				if(!empty($user_ids)){
					global $wp_roles;
					$roles = $wp_roles->get_names();
					$user=get_current_user_id();
					$user_ids=array_diff($user_ids, array($user));
					foreach ($user_ids as $key => $user_id) {
						$requested=get_user_meta($user_id, 'wpwc_user_requested_role', true);
						if(!empty($requested) && isset($roles[$requested])){
							$userId = wp_update_user( array( 'ID' => $user_id, 'role' => $requested ) );
							if (!is_wp_error($userId)){
								do_action('wpwc_user_role_granted',$user_id);
							} 
						}
					}
				}
			}
		    return $redirect_to;
		}
		public function add_custom_filter($which){
			if($which=='top'){
				$status='';
			if ( isset( $_GET['wpwc_users_status'] ) ) {
		        $status = $_GET['wpwc_users_status'];
			    $status = array_filter( $status );
			    $status = reset( $status );
		    }
		    $select = '<select name="wpwc_users_status[]" style="float:none;">';
		    $select .= '<option value="">'.esc_html__("Choose status","wpwc-registration").'</option>';
		    $select .= '<option value="active" '.($status=='active' ? "selected" : "" ).'>'.esc_html__("Active users","wpwc-registration").'</option>';
		    $select .= '<option value="disabled" '.($status=='disabled' ? "selected" : "" ).'>'.esc_html__("Blocked users","wpwc-registration").'</option>';
		    $select .= '</select>';
		    echo $select;
		    submit_button(esc_html__( 'Filter','wpwc_users_status' ), null, $which, false);
			}
		}
		public function filter_users_by_status($query){
			global $pagenow;
		    // if not on users page in admin
		    if ( ! is_admin() || 'users.php' != $pagenow ) {
		        return;
		    } 
		    if ( empty( $_GET['wpwc_users_status'] ) ) {
		        return;
		    }
		    $status = $_GET['wpwc_users_status'];
		    $status = array_filter( $status );
		    $status = reset( $status );
		    if($status=='disabled'){
		    	$args = array(
					    'meta_query' => array(
				            array(
				                'key'     => 'wpwc_user_auth_status',
				                'value'   => 'disabled',
				                'compare' => '='
				            )
					    )
					 );
			    $query->set('meta_query',$args);
			}elseif($status=='active'){
				$args = array(
				    'meta_query' => array(
				        'relation' => 'OR',
				            array(
				                'key'     => 'wpwc_user_auth_status',
				                'value'   => 'disabled',
				                'compare' => '!='
				            ),
				            array(
				                'key'     => 'wpwc_user_auth_status',
				                'value'   => null,
				                'compare' => 'NOT EXISTS'
				            )
				    )
				 );
				$query->set('meta_query',$args);
			}
			return $query;
		}
		public function enqueue_scripts(){
			global $pagenow, $post_type;
			if((isset($_GET['page']) && $_GET['page']=='wpwc-user-registration') || $post_type=='wpwc-custom-fields' || $pagenow=='user-edit.php' || $pagenow=='profile.php'){
				wp_enqueue_media();
				wp_enqueue_style('wpwc-styles', WPWC_REG_URL.'assets/css/backend_style.css','');
				wp_enqueue_script('wpwc-script', WPWC_REG_URL.'assets/js/backend_script.js',array('jquery','jquery-ui-sortable'));
			}
		}
	}
	new WPWC_User_Registration_Backend();
}